;*****************************************************************
;*        Sample Start up Program for TLCS-870/C1 Series         *
;*               Memory Style: Within 64K byte                   *
;*---------------------------------------------------------------*
;*  (C)Copyright TOSHIBA CORPORATION 2008  All rights reserved   *
;*****************************************************************
;*****************************************************************
;File name		:MQ6833_32PinPackage_startup.asm
;Author			:Application Team
;Description	:Template Start up file
;Update date	:2016/05/05
;Version		:v1.0 new build
;*****************************************************************

 		
;=================================================================
; [ External symbol declaration ]
;=================================================================
extern	medium	__RAM_Top	;defined by "ICType".lcf
extern	medium	__RAM_End	;defined by "ICType".lcf
extern	medium	__BaseSP		;defined by "ICType".lcf
extern	medium	_main
extern	small	__TDataAddr,__TDataSize,__TDataOrg
extern	medium	__NDataAddr,__NDataSize,__NDataOrg
;=================================================================
; [ Public symbol declaration ]
;=================================================================
public	_startup                ;set global

module STASM

$include "MQ6833.inc"

;=================================================================
;[ Startup Routine ]
;=================================================================


StartUp	section	code	medium
_startup:

	
;============================================
;disable interrupt
;============================================
	DI

;============================================
;Set CGCR
;============================================
	LD	(CGCR),0x0	;0x0 	fc / 4
					;0x1	fc / 2
					;0x2	fc / 1

;============================================
;initial Registers
;============================================
	LD	WA,0x0
	LD	BC,0x0
	LD	DE,0x0
	LD	HL,0x0
	LD	IX,0x0
	LD	IY,0x0
	
;============================================
;Set P10 to Normal IO	
;============================================	
;	SET	(SYSCR3).0	
;	LD	(SYSCR4),0xb2

;============================================
;Reset Stack Pionter
;============================================
	LD	SP,__BaseSP

;============================================
;Reset PSW 
;============================================
	LD	PSW,0x0

;============================================
;Clear Ram
;!!	If you always modify memory before first read,
;	the "Clear Ram" process is not necessary.
;============================================

	LD	IX,__RAM_Top
	LD	IY,__RAM_End-__RAM_Top
ram_clear:
	LD	(IX),0
	INC	IX
	DEC	IY
	J	F,ram_clear		
	
;============================================
;Initial Global variable
;============================================	

;------initial t_data section-------
	LD	IX,__TDataOrg
	LD  IY,__TDataAddr
	LD	A,__TDataSize
	DEC	A
	J	T,non_t_data
move_t_data:
	LD	C,(IX)
	LD	(IY),C
	INC	IX
	INC	IY
	DEC	A
	J	F,move_t_data
non_t_data:

;------initial n_data section-------
	LD	IX,__NDataOrg
	LD  IY,__NDataAddr
	LD	WA,__NDataSize
	DEC	WA
	J	T,non_n_data
move_n_data:
	LD	C,(IX)
	LD	(IY),C
	INC	IX
	INC	IY
	DEC	WA
	J	F,move_n_data
non_n_data:	
;============================================
;jump to main function
;============================================	
    	J	_main
	
	
	
	end
